#################################################################
# R code: Exercise 9.5
# File: boost.r
#################################################################
rm(list = ls(all = T)) 
library(GAMBoost)
library(mboost)
library(vars)
library(mda)
library(zoo)
source("c:/.../boost_nlar//analysis/functions/helpers-forecasting.R")
source("c:/.../boost_nlar/./analysis/functions/helpers-general.R")
source("c:/.../boost_nlar//analysis/functions/f-VAR.R")

Flowtot  <- read.table("c:/.../flow.dat", quote="\"")
FLtot401 <- ts(Flowtot,freq=1)
Raintot  <- read.table("c:/.../rain.dat", quote="\"")
RNtot401 <- ts(Raintot,freq=1)

#######  Defaults #############################
setup <- list(ychar  = "FLtot401",
              xchar  = c("FLtot401","RNtot401"),   
              iniend = c(366,1),
              maxLag = 12,
              hors   = c(1, 10, 20))

lsstp <- list(setup)

#######  Parameter sets #######################
parset.glmboost <- list(method = "glmboost",
                        mstop = 500,
                        dummy = FALSE)
parset.gamboost <- list(method = "gamboost",
                        df    = 3.5,
                        knots = 20,
                        mstop = 500,
                        dummy = FALSE)
parset.mars  <- list(method = "mars",
                     penalty = "log")
parset.VAR   <- list(method = "VAR",
                    maxLag = setup$maxLag,
                    restrict = FALSE,
                    hor      = NULL,
                    iter     = FALSE)

#######  mboost   with input variable ############
lsglmFLtot2  <- lapply(lsstp,function(z) dir.paradigm(z,parset.glmboost))
lsgamFLtot2  <- lapply(lsstp,function(z) dir.paradigm(z,parset.gamboost))
lsmarsFLtot2 <- lapply(lsstp,function(z) dir.paradigm(z,parset.mars))
lsvarFLtot2  <- lapply(lsstp,function(z) dir.paradigm(z,parset.VAR))